/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dataset;

import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.dataset.SimpleDataSet;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.spi.Registry;
import org.apache.camel.util.StopWatch;
import org.junit.jupiter.api.Test;

public class RoutePerformanceTest
extends ContextTestSupport {
    private final int size = 250;
    private final SimpleDataSet dataSet = new SimpleDataSet(250);
    private final String uri = "mock:results";

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry answer = super.createCamelRegistry();
        answer.bind("foo", (Object)this.dataSet);
        return answer;
    }

    @Test
    public void testPerformance() throws Exception {
        StopWatch watch = new StopWatch();
        MockEndpoint endpoint = this.getMockEndpoint("mock:results");
        endpoint.expectedMessageCount((int)this.dataSet.getSize());
        endpoint.expectedHeaderReceived("foo", (Object)123);
        MockEndpoint.assertIsSatisfied((CamelContext)this.context, (long)30L, (TimeUnit)TimeUnit.SECONDS);
        this.log.info("RoutePerformanceTest: Sent: {} Took: {} ms", (Object)250, (Object)watch.taken());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                HashMap<String, Integer> headers = new HashMap<String, Integer>();
                headers.put("foo", 123);
                RoutePerformanceTest.this.dataSet.setDefaultHeaders(headers);
                this.from("dataset:foo").to("direct:start");
                this.from("direct:start").to(new String[]{"log:a?level=OFF", "log:b?level=OFF", "direct:c"});
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:c").choice().when().header("foo")).to(new String[]{"mock:results", "dataset:foo"})).otherwise().to(new String[]{"mock:results", "dataset:foo"})).end();
            }
        };
    }
}

