/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dataset;

import java.util.LinkedList;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.dataset.ListDataSet;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ListDataSetProducerTest
extends ContextTestSupport {
    protected ListDataSet dataSet = new ListDataSet();
    final String sourceUri = "direct://source";
    final String dataSetName = "foo";
    final String dataSetUri = "dataset://foo";

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry answer = super.createCamelRegistry();
        answer.bind("foo", (Object)this.dataSet);
        return answer;
    }

    @Test
    public void testDefaultListDataSet() throws Exception {
        this.template.sendBodyAndHeader("dataset://foo", (Object)"<hello>world!</hello>", "CamelDataSetIndex", (Object)0);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testDefaultListDataSetWithSizeGreaterThanListSize() throws Exception {
        int messageCount = 10;
        this.getMockEndpoint("dataset://foo").expectedMessageCount(messageCount);
        this.dataSet.setSize((long)messageCount);
        long size = this.dataSet.getSize();
        for (long i = 0L; i < size; ++i) {
            this.template.sendBodyAndHeader("direct://source", (Object)"<hello>world!</hello>", "CamelDataSetIndex", (Object)i);
        }
        this.assertMockEndpointsSatisfied();
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        LinkedList<String> bodies = new LinkedList<String>();
        bodies.add("<hello>world!</hello>");
        this.dataSet = new ListDataSet(bodies);
        super.setUp();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct://source").to("dataset://foo");
            }
        };
    }
}

