/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dataset;

import java.time.Duration;
import java.util.LinkedList;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.dataset.ListDataSet;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ListDataSetConsumerTest
extends ContextTestSupport {
    protected ListDataSet dataSet;
    final String resultUri = "mock://result";
    final String dataSetName = "foo";
    final String dataSetUri = "dataset://foo";

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry answer = super.createCamelRegistry();
        answer.bind("foo", (Object)this.dataSet);
        return answer;
    }

    @Test
    public void testDefaultListDataSet() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock://result");
        result.expectedMinimumMessageCount((int)this.dataSet.getSize());
        result.assertIsSatisfied(Duration.ofSeconds(5L).toMillis());
    }

    @Test
    public void testDefaultListDataSetWithSizeGreaterThanListSize() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock://result");
        this.dataSet.setSize(10L);
        result.expectedMinimumMessageCount((int)this.dataSet.getSize());
        result.assertIsSatisfied(Duration.ofSeconds(5L).toMillis());
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        LinkedList<String> bodies = new LinkedList<String>();
        bodies.add("<hello>world!</hello>");
        this.dataSet = new ListDataSet(bodies);
        super.setUp();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("dataset://foo").to("mock://result");
            }
        };
    }
}

