/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dataset;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.dataset.FileDataSet;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class FileDataSetProducerTest
extends ContextTestSupport {
    @TempDir
    public Path tempFolder;
    protected FileDataSet dataSet;
    final String testPayload = "Line 1\nLine 2\nLine 3\nLine 4\nLine 5\nLine 6\nLine 7\nLine 8\nLine 9\nLine 10\n";
    final String sourceUri = "direct://source";
    final String dataSetName = "foo";
    final String dataSetUri = "dataset://foo";

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry answer = super.createCamelRegistry();
        answer.bind("foo", (Object)this.dataSet);
        return answer;
    }

    @Test
    public void testDefaultListDataSet() throws Exception {
        this.template.sendBodyAndHeader("direct://source", (Object)"Line 1\nLine 2\nLine 3\nLine 4\nLine 5\nLine 6\nLine 7\nLine 8\nLine 9\nLine 10\n", "CamelDataSetIndex", (Object)0);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testDefaultListDataSetWithSizeGreaterThanListSize() throws Exception {
        int messageCount = 20;
        this.dataSet.setSize((long)messageCount);
        this.getMockEndpoint("dataset://foo").expectedMessageCount(messageCount);
        for (int i = 0; i < messageCount; ++i) {
            this.template.sendBodyAndHeader("direct://source", (Object)"Line 1\nLine 2\nLine 3\nLine 4\nLine 5\nLine 6\nLine 7\nLine 8\nLine 9\nLine 10\n", "CamelDataSetIndex", (Object)i);
        }
        this.assertMockEndpointsSatisfied();
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        File fileDataset = this.createFileDataset();
        this.dataSet = new FileDataSet(fileDataset);
        Assertions.assertEquals((long)1L, (long)this.dataSet.getSize(), (String)"Unexpected DataSet size");
        super.setUp();
    }

    private File createFileDataset() throws IOException {
        Files.createDirectories(this.tempFolder, new FileAttribute[0]);
        Path fileDataset = this.tempFolder.resolve("file-dataset-test.txt");
        Files.copy(new ByteArrayInputStream("Line 1\nLine 2\nLine 3\nLine 4\nLine 5\nLine 6\nLine 7\nLine 8\nLine 9\nLine 10\n".getBytes()), fileDataset, StandardCopyOption.REPLACE_EXISTING);
        return fileDataset.toFile();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct://source").to("dataset://foo");
            }
        };
    }
}

