/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dataset;

import java.time.Duration;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.dataset.FileDataSet;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FileDataSetConsumerWithSplitTest
extends ContextTestSupport {
    protected FileDataSet dataSet;
    final String testDataFileName = "src/test/data/file-dataset-test.txt";
    final int testDataFileRecordCount = 10;
    final String resultUri = "mock://result";
    final String dataSetName = "foo";
    final String dataSetUri = "dataset://foo";

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry answer = super.createCamelRegistry();
        answer.bind("foo", (Object)this.dataSet);
        return answer;
    }

    @Test
    public void testDefaultListDataSet() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock://result");
        result.expectedMinimumMessageCount((int)this.dataSet.getSize());
        result.assertIsSatisfied(Duration.ofSeconds(5L).toMillis());
    }

    @Test
    public void testDefaultListDataSetWithSizeGreaterThanListSize() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock://result");
        this.dataSet.setSize(20L);
        result.expectedMinimumMessageCount((int)this.dataSet.getSize());
        result.assertIsSatisfied(Duration.ofSeconds(5L).toMillis());
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        this.dataSet = new FileDataSet("src/test/data/file-dataset-test.txt", "\n");
        Assumptions.assumeTrue((10L == this.dataSet.getSize() ? 1 : 0) != 0, (String)"Unexpected DataSet size");
        super.setUp();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("dataset://foo").to("mock://result");
            }
        };
    }
}

