/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dataset;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.dataset.FileDataSet;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FileDataSetConsumerTest
extends ContextTestSupport {
    protected FileDataSet dataSet;
    final String testDataFileName = "src/test/data/file-dataset-test.txt";
    final String resultUri = "mock://result";
    final String dataSetName = "foo";
    final String dataSetUri = "dataset://foo";

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry answer = super.createCamelRegistry();
        answer.bind("foo", (Object)this.dataSet);
        return answer;
    }

    @Test
    public void testDefaultListDataSet() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock://result");
        result.expectedMinimumMessageCount((int)this.dataSet.getSize());
        result.assertIsSatisfied();
    }

    @Test
    public void testDefaultListDataSetWithSizeGreaterThanListSize() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock://result");
        this.dataSet.setSize(20L);
        result.expectedMinimumMessageCount((int)this.dataSet.getSize());
        result.assertIsSatisfied();
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        this.dataSet = new FileDataSet("src/test/data/file-dataset-test.txt");
        Assertions.assertEquals((long)1L, (long)this.dataSet.getSize(), (String)"Unexpected DataSet size");
        super.setUp();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("dataset://foo").to("mock://result");
            }
        };
    }
}

