/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dataset;

import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.DefaultExchange;
import org.junit.jupiter.api.Test;

public class DataSetTestEndpointTest
extends ContextTestSupport {
    private final String expectedBody = "Hello World";

    @Test
    public void testMocksAreValid() throws Exception {
        this.template.sendBody("seda:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() throws Exception {
                MyEndpoint my = new MyEndpoint("my:foo", (CamelContext)DataSetTestEndpointTest.this.context);
                DataSetTestEndpointTest.this.context.addEndpoint("my:foo", (Endpoint)my);
                this.from("seda:foo").to("dataset-test:my:foo?timeout=0");
            }
        };
    }

    private final class MyEndpoint
    extends DefaultEndpoint {
        private MyEndpoint(String endpointUri, CamelContext camelContext) {
            super(endpointUri, null);
            this.setCamelContext(camelContext);
        }

        public Producer createProducer() {
            return null;
        }

        public Consumer createConsumer(final Processor processor) {
            return new Consumer(){

                public Endpoint getEndpoint() {
                    return MyEndpoint.this;
                }

                public Processor getProcessor() {
                    return null;
                }

                public Exchange createExchange(boolean autoRelease) {
                    return DefaultExchange.newFromEndpoint((Endpoint)this.getEndpoint());
                }

                public void releaseExchange(Exchange exchange, boolean autoRelease) {
                }

                public void start() {
                    Exchange exchange = this.createExchange(false);
                    exchange.getIn().setBody((Object)"Hello World");
                    try {
                        processor.process(exchange);
                    }
                    catch (Exception e) {
                        throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
                    }
                }

                public void stop() {
                }
            };
        }

        public boolean isSingleton() {
            return true;
        }
    }
}

