/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dataset;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.dataset.SimpleDataSet;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Test;

public class DataSetSedaTest
extends ContextTestSupport {
    private final SimpleDataSet dataSet = new SimpleDataSet(200);
    private final String uri = "dataset:foo?initialDelay=0&produceDelay=1";

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry answer = super.createCamelRegistry();
        answer.bind("foo", (Object)this.dataSet);
        return answer;
    }

    @Test
    public void testDataSetWithSeda() throws Exception {
        MockEndpoint endpoint = this.getMockEndpoint("dataset:foo?initialDelay=0&produceDelay=1");
        endpoint.expectedMessageCount((int)this.dataSet.getSize());
        this.context.getRouteController().startAllRoutes();
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("dataset:foo?initialDelay=0&produceDelay=1").to("seda:test")).autoStartup(false);
                this.from("seda:test").to("dataset:foo?initialDelay=0&produceDelay=1");
            }
        };
    }
}

