/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dataset;

import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Expression;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.dataset.SimpleDataSet;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class DataSetProducerTest
extends ContextTestSupport {
    protected final SimpleDataSet dataSet = new SimpleDataSet(20);
    final String dataSetName = "foo";
    final String dataSetUri = "dataset://foo";
    final String dataSetUriWithDataSetIndexSetToOff = "dataset://foo?dataSetIndex=off";
    final String dataSetUriWithDataSetIndexSetToLenient = "dataset://foo?dataSetIndex=lenient";
    final String dataSetUriWithDataSetIndexSetToStrict = "dataset://foo?dataSetIndex=strict";
    final String sourceUri = "direct://source";
    final String resultUri = "mock://result";

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry answer = super.createCamelRegistry();
        answer.bind("foo", (Object)this.dataSet);
        return answer;
    }

    @Test
    public void testSendingMessagesExplicitlyToDataSetEndpointWithDataSetIndexHeader() throws Exception {
        long size = this.dataSet.getSize();
        for (long i = 0L; i < size; ++i) {
            this.template.sendBodyAndHeader("dataset://foo", this.dataSet.getDefaultBody(), "CamelDataSetIndex", (Object)i);
        }
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSendingMessagesExplicitlyToDataSetEndpointWithoutDataSetIndexHeader() throws Exception {
        long size = this.dataSet.getSize();
        for (long i = 0L; i < size; ++i) {
            this.template.sendBody("dataset://foo", this.dataSet.getDefaultBody());
        }
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSendingMessagesExplicitlyToDataSetEndpointWithoutDataSetIndexAndDataSetIndexUriParameterSetToOff() throws Exception {
        long size = this.dataSet.getSize();
        for (long i = 0L; i < size; ++i) {
            if (0L == i % 2L) {
                this.template.sendBodyAndHeader("dataset://foo?dataSetIndex=lenient", this.dataSet.getDefaultBody(), "CamelDataSetIndex", (Object)i);
                continue;
            }
            this.template.sendBody("dataset://foo?dataSetIndex=lenient", this.dataSet.getDefaultBody());
        }
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSendingMessagesExplicitlyToDataSetEndpointWithoutDataSetIndexAndDataSetIndexUriParameterSetToLenient() throws Exception {
        long size = this.dataSet.getSize();
        for (long i = 0L; i < size; ++i) {
            if (0L == i % 2L) {
                this.template.sendBodyAndHeader("dataset://foo?dataSetIndex=lenient", this.dataSet.getDefaultBody(), "CamelDataSetIndex", (Object)i);
                continue;
            }
            this.template.sendBody("dataset://foo?dataSetIndex=lenient", this.dataSet.getDefaultBody());
        }
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSendingMessagesExplicitlyToDataSetEndpointWithoutDataSetIndexAndDataSetIndexUriParameterSetToStrict() throws Exception {
        long size = this.dataSet.getSize();
        for (long i = 0L; i < size; ++i) {
            this.template.sendBodyAndHeader("dataset://foo?dataSetIndex=strict", this.dataSet.getDefaultBody(), "CamelDataSetIndex", (Object)i);
        }
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testNotSettingDataSetIndexHeaderWhenDataSetIndexUriParameterIsUnset() throws Exception {
        long size = this.dataSet.getSize();
        for (long i = 0L; i < size; ++i) {
            if (0L == size % 2L) {
                this.template.sendBodyAndHeader("dataset://foo", this.dataSet.getDefaultBody(), "CamelDataSetIndex", (Object)i);
                continue;
            }
            this.template.sendBody("dataset://foo", this.dataSet.getDefaultBody());
        }
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testNotSettingDataSetIndexHeaderWhenDataSetIndexUriParameterSetToOff() throws Exception {
        long size = this.dataSet.getSize();
        for (long i = 0L; i < size; ++i) {
            if (0L == size % 2L) {
                this.template.sendBodyAndHeader("dataset://foo?dataSetIndex=off", this.dataSet.getDefaultBody(), "CamelDataSetIndex", (Object)(size - i));
                continue;
            }
            this.template.sendBody("dataset://foo?dataSetIndex=off", this.dataSet.getDefaultBody());
        }
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testNotSettingDataSetIndexHeaderWhenDataSetIndexUriParameterSetToLenient() throws Exception {
        long size = this.dataSet.getSize();
        for (long i = 0L; i < size; ++i) {
            if (0L == size % 2L) {
                this.template.sendBodyAndHeader("dataset://foo?dataSetIndex=lenient", this.dataSet.getDefaultBody(), "CamelDataSetIndex", (Object)i);
                continue;
            }
            this.template.sendBody("dataset://foo?dataSetIndex=lenient", this.dataSet.getDefaultBody());
        }
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testNotSettingDataSetIndexHeaderWhenDataSetIndexUriParameterSetToStrict() throws Exception {
        long size = this.dataSet.getSize();
        for (long i = 0L; i < size; ++i) {
            this.template.sendBody("dataset://foo?dataSetIndex=strict", this.dataSet.getDefaultBody());
        }
        String expectedErrorString = "Caught exception on dataset://foo?dataSetIndex=strict due to: No 'CamelDataSetIndex' header available of type: java.lang.Long";
        List<Endpoint> endpoints = this.context.getEndpoints().stream().filter(e -> e.getEndpointUri().startsWith("dataset://foo?dataSetIndex=strict")).toList();
        for (Endpoint endpoint : endpoints) {
            Assertions.assertThat((Object)endpoint).isInstanceOf(MockEndpoint.class);
            ((MockEndpoint)endpoint).assertIsNotSatisfied(expectedErrorString);
        }
    }

    @Test
    public void testDataSetIndexUriParameterUnset() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct://source").to("dataset://foo")).to("mock://result");
            }
        });
        this.context.start();
        long size = this.dataSet.getSize();
        MockEndpoint result = this.getMockEndpoint("mock://result");
        result.expectedMessageCount((int)size);
        ((MockValueBuilder)result.allMessages().header("CamelDataSetIndex")).isNotNull();
        result.expectsAscending((Expression)DataSetProducerTest.header("CamelDataSetIndex").convertTo(Number.class));
        for (long i = 0L; i < size; ++i) {
            this.template.sendBody("direct://source", this.dataSet.getDefaultBody());
        }
        this.assertMockEndpointsSatisfied();
        result.assertMessagesAscending((Expression)DataSetProducerTest.header("CamelDataSetIndex").convertTo(Number.class));
    }

    @Test
    public void testDataSetIndexUriParameterSetToOff() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct://source").to("dataset://foo?dataSetIndex=off")).to("mock://result");
            }
        });
        this.context.start();
        long size = this.dataSet.getSize();
        MockEndpoint result = this.getMockEndpoint("mock://result");
        result.expectedMessageCount((int)size);
        result.expectsAscending((Expression)DataSetProducerTest.header("CamelDataSetIndex").convertTo(Number.class));
        ((MockValueBuilder)result.allMessages().header("CamelDataSetIndex")).isNotNull();
        for (long i = 0L; i < size; ++i) {
            this.template.sendBodyAndHeader("direct://source", this.dataSet.getDefaultBody(), "CamelDataSetIndex", (Object)i);
        }
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testDataSetIndexUriParameterSetToLenient() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct://source").to("dataset://foo?dataSetIndex=lenient")).to("mock://result");
            }
        });
        this.context.start();
        long size = this.dataSet.getSize();
        MockEndpoint result = this.getMockEndpoint("mock://result");
        result.expectedMessageCount((int)size);
        result.expectsAscending((Expression)DataSetProducerTest.header("CamelDataSetIndex").convertTo(Number.class));
        ((MockValueBuilder)result.allMessages().header("CamelDataSetIndex")).isNotNull();
        for (long i = 0L; i < size; ++i) {
            this.template.sendBodyAndHeader("direct://source", this.dataSet.getDefaultBody(), "CamelDataSetIndex", (Object)i);
        }
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testDataSetIndexUriParameterSetToStrict() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct://source").to("dataset://foo?dataSetIndex=strict")).to("mock://result");
            }
        });
        this.context.start();
        long size = this.dataSet.getSize();
        MockEndpoint result = this.getMockEndpoint("mock://result");
        result.expectedMessageCount((int)size);
        result.expectsAscending((Expression)DataSetProducerTest.header("CamelDataSetIndex").convertTo(Number.class));
        ((MockValueBuilder)result.allMessages().header("CamelDataSetIndex")).isNotNull();
        for (long i = 0L; i < size; ++i) {
            this.template.sendBodyAndHeader("direct://source", this.dataSet.getDefaultBody(), "CamelDataSetIndex", (Object)i);
        }
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testInvalidDataSetIndexValueWithDataSetIndexUriParameterUnset() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct://source").to("dataset://foo")).to("mock://result");
            }
        });
        this.context.start();
        long size = this.dataSet.getSize();
        MockEndpoint result = this.getMockEndpoint("mock://result");
        result.expectedMessageCount((int)size);
        ((MockValueBuilder)result.allMessages().header("CamelDataSetIndex")).isNotNull();
        for (long i = 0L; i < size; ++i) {
            if (i == size / 2L) {
                this.template.sendBodyAndHeader("direct://source", this.dataSet.getDefaultBody(), "CamelDataSetIndex", (Object)(i + 10L));
                continue;
            }
            this.template.sendBody("direct://source", this.dataSet.getDefaultBody());
        }
        String expectedErrorString = "Caught exception on dataset://foo due to: Header: CamelDataSetIndex does not match. Expected: " + size / 2L + " but was: " + (size / 2L + 10L);
        List<Endpoint> endpoints = this.context.getEndpoints().stream().filter(e -> e.getEndpointUri().startsWith("dataset://foo")).toList();
        for (Endpoint endpoint : endpoints) {
            Assertions.assertThat((Object)endpoint).isInstanceOf(MockEndpoint.class);
            ((MockEndpoint)endpoint).assertIsNotSatisfied(expectedErrorString);
        }
    }

    @Test
    public void testInvalidDataSetIndexValueWithDataSetIndexUriParameterSetToOff() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct://source").to("dataset://foo?dataSetIndex=off")).to("mock://result");
            }
        });
        this.context.start();
        long size = this.dataSet.getSize();
        MockEndpoint result = this.getMockEndpoint("mock://result");
        result.expectedMessageCount((int)size);
        for (long i = 0L; i < size; ++i) {
            if (i == size / 2L) {
                this.template.sendBodyAndHeader("direct://source", this.dataSet.getDefaultBody(), "CamelDataSetIndex", (Object)(i + 10L));
                continue;
            }
            this.template.sendBody("direct://source", this.dataSet.getDefaultBody());
        }
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testInvalidDataSetIndexValueWithDataSetIndexUriParameterSetToLenient() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct://source").to("dataset://foo?dataSetIndex=lenient")).to("mock://result");
            }
        });
        this.context.start();
        long size = this.dataSet.getSize();
        MockEndpoint result = this.getMockEndpoint("mock://result");
        result.expectedMessageCount((int)size);
        ((MockValueBuilder)result.allMessages().header("CamelDataSetIndex")).isNotNull();
        for (long i = 0L; i < size; ++i) {
            if (i == size / 2L) {
                this.template.sendBodyAndHeader("direct://source", this.dataSet.getDefaultBody(), "CamelDataSetIndex", (Object)(i + 10L));
                continue;
            }
            this.template.sendBody("direct://source", this.dataSet.getDefaultBody());
        }
        String expectedErrorString = "Caught exception on dataset://foo?dataSetIndex=lenient due to: Header: CamelDataSetIndex does not match. Expected: " + size / 2L + " but was: " + (size / 2L + 10L);
        List<Endpoint> endpoints = this.context.getEndpoints().stream().filter(e -> e.getEndpointUri().startsWith("dataset://foo?dataSetIndex=lenient")).toList();
        for (Endpoint endpoint : endpoints) {
            Assertions.assertThat((Object)endpoint).isInstanceOf(MockEndpoint.class);
            ((MockEndpoint)endpoint).assertIsNotSatisfied(expectedErrorString);
        }
    }

    @Test
    public void testInvalidDataSetIndexValueWithDataSetIndexUriParameterSetToStrict() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct://source").to("dataset://foo?dataSetIndex=strict")).to("mock://result");
            }
        });
        this.context.start();
        long size = this.dataSet.getSize();
        MockEndpoint result = this.getMockEndpoint("mock://result");
        result.expectedMessageCount((int)size);
        ((MockValueBuilder)result.allMessages().header("CamelDataSetIndex")).isNotNull();
        for (long i = 0L; i < size; ++i) {
            if (i == size / 2L) {
                this.template.sendBodyAndHeader("direct://source", this.dataSet.getDefaultBody(), "CamelDataSetIndex", (Object)(i + 10L));
                continue;
            }
            this.template.sendBodyAndHeader("direct://source", this.dataSet.getDefaultBody(), "CamelDataSetIndex", (Object)i);
        }
        String expectedErrorString = "Caught exception on dataset://foo?dataSetIndex=strict due to: Header: CamelDataSetIndex does not match. Expected: " + size / 2L + " but was: " + (size / 2L + 10L);
        List<Endpoint> endpoints = this.context.getEndpoints().stream().filter(e -> e.getEndpointUri().startsWith("dataset://foo?dataSetIndex=strict")).toList();
        for (Endpoint endpoint : endpoints) {
            Assertions.assertThat((Object)endpoint).isInstanceOf(MockEndpoint.class);
            ((MockEndpoint)endpoint).assertIsNotSatisfied(expectedErrorString);
        }
    }
}

