/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dataset;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.dataset.DataSetEndpoint;
import org.apache.camel.component.dataset.SimpleDataSet;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DataSetPreloadTest
extends ContextTestSupport {
    private final SimpleDataSet dataSet = new SimpleDataSet(20);
    private final String uri = "dataset:foo?initialDelay=0&preloadSize=5";

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry answer = super.createCamelRegistry();
        answer.bind("foo", (Object)this.dataSet);
        return answer;
    }

    @Test
    public void testDataSetPreloadSize() throws Exception {
        MockEndpoint endpoint = this.getMockEndpoint("dataset:foo?initialDelay=0&preloadSize=5");
        endpoint.expectedMessageCount((int)this.dataSet.getSize());
        this.context.getRouteController().startAllRoutes();
        this.assertMockEndpointsSatisfied();
        DataSetEndpoint ds = (DataSetEndpoint)this.context.getEndpoint("dataset:foo?initialDelay=0&preloadSize=5", DataSetEndpoint.class);
        Assertions.assertEquals((long)5L, (long)ds.getPreloadSize());
        ds.setPreloadSize(7L);
        Assertions.assertEquals((long)7L, (long)ds.getPreloadSize());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("dataset:foo?initialDelay=0&preloadSize=5").to("seda:test")).autoStartup(false);
                this.from("seda:test").to("dataset:foo?initialDelay=0&preloadSize=5");
            }
        };
    }
}

