/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dataset;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.dataset.DataSet;
import org.apache.camel.component.dataset.DataSetEndpoint;
import org.apache.camel.component.dataset.DataSetSupport;
import org.apache.camel.component.dataset.SimpleDataSet;
import org.apache.camel.component.mock.MockValueBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DataSetEndpointTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testDataSetEndpoint() throws Exception {
        final DataSetEndpoint endpoint = new DataSetEndpoint("dataset://foo", null, (DataSet)new SimpleDataSet(2));
        endpoint.setCamelContext((CamelContext)this.context);
        endpoint.setInitialDelay(0L);
        Assertions.assertEquals((long)0L, (long)endpoint.getPreloadSize());
        Assertions.assertEquals((long)0L, (long)endpoint.getConsumeDelay());
        Assertions.assertEquals((long)3L, (long)endpoint.getProduceDelay());
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from((Endpoint)endpoint).to("direct:foo");
                this.from("direct:foo").to((Endpoint)endpoint);
            }
        });
        this.context.start();
        endpoint.assertIsSatisfied();
    }

    @Test
    public void testDataSetEndpointCtr() throws Exception {
        final DataSetEndpoint endpoint = new DataSetEndpoint("dataset://foo", this.context.getComponent("dataset"), (DataSet)new SimpleDataSet(2));
        endpoint.setConsumeDelay(2L);
        Assertions.assertEquals((long)2L, (long)endpoint.getConsumeDelay());
        endpoint.setProduceDelay(5L);
        Assertions.assertEquals((long)5L, (long)endpoint.getProduceDelay());
        endpoint.setInitialDelay(1L);
        Assertions.assertEquals((long)1L, (long)endpoint.getInitialDelay());
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from((Endpoint)endpoint).to("direct:foo");
                this.from("direct:foo").to((Endpoint)endpoint);
            }
        });
        this.context.start();
        endpoint.assertIsSatisfied();
    }

    @Test
    public void testDataSetReporter() throws Exception {
        final DataSetEndpoint endpoint = new DataSetEndpoint("dataset://foo", this.context.getComponent("dataset"), (DataSet)new SimpleDataSet(10));
        endpoint.setInitialDelay(0L);
        final AtomicBoolean reported = new AtomicBoolean();
        endpoint.setReporter(new Processor(){

            public void process(Exchange exchange) {
                reported.set(true);
            }
        });
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from((Endpoint)endpoint).to("direct:foo");
                this.from("direct:foo").to((Endpoint)endpoint);
            }
        });
        this.context.start();
        endpoint.assertIsSatisfied();
        Assertions.assertTrue((boolean)reported.get());
    }

    @Test
    public void testSimpleDataSet() {
        SimpleDataSet ds = new SimpleDataSet();
        ds.setSize(2L);
        ds.setDefaultBody((Object)"Hi");
        Assertions.assertEquals((Object)"Hi", (Object)ds.getDefaultBody());
    }

    @Test
    public void testDataSetSupport() throws Exception {
        MyDataSet ds = new MyDataSet();
        ds.setSize(4L);
        ds.setReportCount(0L);
        ds.setOutputTransformer(new Processor(){

            public void process(Exchange exchange) {
                String body = "Hi " + (String)exchange.getIn().getBody(String.class);
                exchange.getIn().setBody((Object)body);
            }
        });
        Assertions.assertNotNull((Object)ds.getOutputTransformer());
        final DataSetEndpoint endpoint = new DataSetEndpoint("dataset://foo", this.context.getComponent("dataset"), (DataSet)ds);
        endpoint.setInitialDelay(0L);
        ((MockValueBuilder)endpoint.allMessages().body()).startsWith((Object)"Hi ");
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from((Endpoint)endpoint).to("direct:foo");
                this.from("direct:foo").to((Endpoint)endpoint);
            }
        });
        this.context.start();
        endpoint.assertIsSatisfied();
    }

    private static class MyDataSet
    extends DataSetSupport {
        private MyDataSet() {
        }

        protected Object createMessageBody(long messageIndex) {
            return "Message " + messageIndex;
        }
    }
}

