/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dataset;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.dataset.SimpleDataSet;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DataSetConsumerTest
extends ContextTestSupport {
    protected final SimpleDataSet dataSet = new SimpleDataSet(5);
    final String dataSetName = "foo";
    final String dataSetUri = "dataset://foo?initialDelay=0";
    final String dataSetUriWithDataSetIndexSetToOff = "dataset://foo?initialDelay=0&dataSetIndex=off";
    final String dataSetUriWithDataSetIndexSetToLenient = "dataset://foo?initialDelay=0&dataSetIndex=lenient";
    final String dataSetUriWithDataSetIndexSetToStrict = "dataset://foo?initialDelay=0&dataSetIndex=strict";
    final String resultUri = "mock://result";

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry answer = super.createCamelRegistry();
        answer.bind("foo", (Object)this.dataSet);
        return answer;
    }

    @Test
    public void testConsumerOnlyEndpoint() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("dataset://foo?initialDelay=0").to("mock://result");
            }
        });
        Assertions.assertEquals((int)-1, (int)this.getMockEndpoint("dataset://foo?initialDelay=0").getExpectedCount(), (String)"expectedMessageCount should be unset(i.e. -1) for a consumer-only endpoint");
        MockEndpoint result = this.getMockEndpoint("mock://result");
        result.expectedMessageCount((int)this.dataSet.getSize());
        result.assertMessagesAscending((Expression)DataSetConsumerTest.header("CamelDataSetIndex"));
        this.context.start();
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testConsumerWithProducer() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("dataset://foo?initialDelay=0").to("dataset://foo?initialDelay=0")).to("mock://result");
            }
        });
        Assertions.assertEquals((long)this.dataSet.getSize(), (long)this.getMockEndpoint("dataset://foo?initialDelay=0").getExpectedCount(), (String)"expectedMessageCount should be the same as the DataSet size for a consumer-producer endpoint");
        MockEndpoint result = this.getMockEndpoint("mock://result");
        result.expectedMessageCount((int)this.dataSet.getSize());
        result.expectsAscending((Expression)DataSetConsumerTest.header("CamelDataSetIndex").convertTo(Number.class));
        this.context.start();
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testWithDataSetIndexUriParameterUnset() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("dataset://foo?initialDelay=0").to("mock://result");
            }
        });
        MockEndpoint result = this.getMockEndpoint("mock://result");
        result.expectedMessageCount((int)this.dataSet.getSize());
        ((MockValueBuilder)result.allMessages().header("CamelDataSetIndex")).isNotNull();
        result.expectsAscending((Expression)DataSetConsumerTest.header("CamelDataSetIndex").convertTo(Number.class));
        this.context.start();
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testWithDataSetIndexUriParameterSetToOff() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("dataset://foo?initialDelay=0&dataSetIndex=off").to("mock://result");
            }
        });
        MockEndpoint result = this.getMockEndpoint("mock://result");
        result.expectedMessageCount((int)this.dataSet.getSize());
        ((MockValueBuilder)result.allMessages().header("CamelDataSetIndex")).isNull();
        this.context.start();
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testWithDataSetIndexUriParameterSetToLenient() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("dataset://foo?initialDelay=0&dataSetIndex=lenient").to("mock://result");
            }
        });
        MockEndpoint result = this.getMockEndpoint("mock://result");
        result.expectedMessageCount((int)this.dataSet.getSize());
        ((MockValueBuilder)result.allMessages().header("CamelDataSetIndex")).isNotNull();
        result.expectsAscending((Expression)DataSetConsumerTest.header("CamelDataSetIndex").convertTo(Number.class));
        this.context.start();
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testWithDataSetIndexUriParameterSetToStrict() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("dataset://foo?initialDelay=0&dataSetIndex=strict").to("mock://result");
            }
        });
        MockEndpoint result = this.getMockEndpoint("mock://result");
        result.expectedMessageCount((int)this.dataSet.getSize());
        ((MockValueBuilder)result.allMessages().header("CamelDataSetIndex")).isNotNull();
        result.expectsAscending((Expression)DataSetConsumerTest.header("CamelDataSetIndex").convertTo(Number.class));
        this.context.start();
        this.assertMockEndpointsSatisfied();
    }
}

