/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dataset;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.builder.PredicateBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.dataset.DataSet;
import org.apache.camel.component.dataset.DataSetEndpoint;
import org.apache.camel.component.dataset.DataSetSupport;
import org.apache.camel.language.xpath.XPathBuilder;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.PredicateAssertHelper;
import org.junit.jupiter.api.Test;

public class CustomDataSetTest
extends ContextTestSupport {
    protected final DataSet dataSet = new DataSetSupport(){
        final Expression expression = new XPathBuilder("/message/@index").resultType(Long.class);

        public void assertMessageExpected(DataSetEndpoint dataSetEndpoint, Exchange expected, Exchange actual, long index) {
            Predicate predicate = PredicateBuilder.isEqualTo((Expression)this.expression, (Expression)ExpressionBuilder.constantExpression((Object)index));
            CustomDataSetTest.this.log.debug("evaluating predicate: {}", (Object)predicate);
            PredicateAssertHelper.assertMatches((Predicate)predicate, (String)("Actual: " + String.valueOf(actual)), (Exchange)actual);
        }

        protected Object createMessageBody(long messageIndex) {
            return "<message index='" + messageIndex + "'>someBody" + messageIndex + "</message>";
        }
    };

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry answer = super.createCamelRegistry();
        answer.bind("foo", (Object)this.dataSet);
        return answer;
    }

    @Test
    public void testUsingCustomDataSet() throws Exception {
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("dataset:foo?initialDelay=0").to("direct:foo");
                this.from("direct:foo").to("dataset:foo?initialDelay=0");
            }
        };
    }
}

