/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.controlbus;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ControlBusStartRouteTest
extends ContextTestSupport {
    @Test
    public void testControlBusStartStop() throws Exception {
        Assertions.assertEquals((Object)"Stopped", (Object)this.context.getRouteController().getRouteStatus("foo").name());
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("seda:foo", (Object)"Hello World");
        this.template.sendBody("controlbus:route?routeId=foo&action=start", null);
        this.assertMockEndpointsSatisfied();
        this.template.sendBody("controlbus:route?routeId=foo&action=stop", null);
        Assertions.assertEquals((Object)"Stopped", (Object)this.context.getRouteController().getRouteStatus("foo").name());
    }

    @Test
    public void testControlBusSuspendResume() throws Exception {
        Assertions.assertEquals((Object)"Stopped", (Object)this.context.getRouteController().getRouteStatus("foo").name());
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("seda:foo", (Object)"Hello World");
        this.template.sendBody("controlbus:route?routeId=foo&action=start", null);
        this.assertMockEndpointsSatisfied();
        this.template.sendBody("controlbus:route?routeId=foo&action=suspend", null);
        Assertions.assertEquals((Object)"Suspended", (Object)this.context.getRouteController().getRouteStatus("foo").name());
        this.template.sendBody("controlbus:route?routeId=foo&action=resume", null);
        Assertions.assertEquals((Object)"Started", (Object)this.context.getRouteController().getRouteStatus("foo").name());
    }

    @Test
    public void testControlBusStatus() throws Exception {
        Assertions.assertEquals((Object)"Stopped", (Object)this.context.getRouteController().getRouteStatus("foo").name());
        String status = (String)this.template.requestBody("controlbus:route?routeId=foo&action=status", null, String.class);
        Assertions.assertEquals((Object)"Stopped", (Object)status);
        this.context.getRouteController().startRoute("foo");
        status = (String)this.template.requestBody("controlbus:route?routeId=foo&action=status", null, String.class);
        Assertions.assertEquals((Object)"Started", (Object)status);
    }

    @Test
    public void testControlBusCurrentRouteStatus() throws Exception {
        Assertions.assertTrue((boolean)this.context.getRouteController().getRouteStatus("current").isStarted());
        MockEndpoint mock = this.getMockEndpoint("mock:current");
        mock.expectedMessageCount(1);
        mock.expectedBodiesReceived(new Object[]{ServiceStatus.Started.name()});
        this.sendBody("seda:current", null);
        mock.assertIsSatisfied();
    }

    @Test
    public void testControlBusStatusLevelWarn() throws Exception {
        Assertions.assertEquals((Object)"Stopped", (Object)this.context.getRouteController().getRouteStatus("foo").name());
        String status = (String)this.template.requestBody("controlbus:route?routeId=foo&action=status&loggingLevel=WARN", null, String.class);
        Assertions.assertEquals((Object)"Stopped", (Object)status);
        this.context.getRouteController().startRoute("foo");
        status = (String)this.template.requestBody("controlbus:route?routeId=foo&action=status&loggingLevel=WARN", null, String.class);
        Assertions.assertEquals((Object)"Started", (Object)status);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("seda:foo").routeId("foo").autoStartup(false).to("mock:foo");
                ((RouteDefinition)this.from("seda:current").routeId("current").to("controlbus:route?routeId=current&action=status&loggingLevel=WARN")).to("mock:current");
            }
        };
    }
}

