/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.controlbus;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Route;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.support.RoutePolicySupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ControlBusRestartRouteTest
extends ContextTestSupport {
    private final MyRoutePolicy myRoutePolicy = new MyRoutePolicy();

    @Test
    public void testControlBusRestart() {
        Assertions.assertEquals((int)1, (int)this.myRoutePolicy.getStart());
        Assertions.assertEquals((int)0, (int)this.myRoutePolicy.getStop());
        Assertions.assertEquals((Object)"Started", (Object)this.context.getRouteController().getRouteStatus("foo").name());
        this.template.sendBody("controlbus:route?routeId=foo&action=restart&restartDelay=0", null);
        Assertions.assertEquals((Object)"Started", (Object)this.context.getRouteController().getRouteStatus("foo").name());
        Assertions.assertEquals((int)2, (int)this.myRoutePolicy.getStart());
        Assertions.assertEquals((int)1, (int)this.myRoutePolicy.getStop());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("seda:foo").routeId("foo").routePolicy(new RoutePolicy[]{ControlBusRestartRouteTest.this.myRoutePolicy}).to("mock:foo");
            }
        };
    }

    private static final class MyRoutePolicy
    extends RoutePolicySupport {
        private int start;
        private int stop;

        private MyRoutePolicy() {
        }

        public void onStart(Route route) {
            ++this.start;
        }

        public void onStop(Route route) {
            ++this.stop;
        }

        public int getStart() {
            return this.start;
        }

        public int getStop() {
            return this.stop;
        }
    }
}

