/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.controlbus;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ControlBusLanguageSimpleStartRouteTest
extends ContextTestSupport {
    @Test
    public void testControlBusStartStop() throws Exception {
        Assertions.assertEquals((Object)"Stopped", (Object)this.context.getRouteController().getRouteStatus("foo").name());
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("seda:foo", (Object)"Hello World");
        this.template.sendBody("controlbus:language:simple", (Object)"${camelContext.getRouteController().startRoute('foo')}");
        this.assertMockEndpointsSatisfied();
        this.template.sendBodyAndHeader("controlbus:language:simple", (Object)"${camelContext.getRouteController().stopRoute(${header.me})}", "me", (Object)"foo");
        Assertions.assertEquals((Object)"Stopped", (Object)this.context.getRouteController().getRouteStatus("foo").name());
    }

    @Test
    public void testControlBusStatus() throws Exception {
        Assertions.assertEquals((Object)"Stopped", (Object)this.context.getRouteController().getRouteStatus("foo").name());
        String status = (String)this.template.requestBody("controlbus:language:simple", (Object)"${camelContext.getRouteController().getRouteStatus('foo')}", String.class);
        Assertions.assertEquals((Object)"Stopped", (Object)status);
        this.context.getRouteController().startRoute("foo");
        status = (String)this.template.requestBody("controlbus:language:simple", (Object)"${camelContext.getRouteController().getRouteStatus('foo')}", String.class);
        Assertions.assertEquals((Object)"Started", (Object)status);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("seda:foo").routeId("foo").autoStartup(false).to("mock:foo");
            }
        };
    }
}

