/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.controlbus;

import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Route;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.spi.RouteController;
import org.apache.camel.spi.RouteError;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledIfSystemProperty;

@DisabledIfSystemProperty(named="ci.env.name", matches=".*", disabledReason="Flaky test on CI environments")
public class ControlBusFailRouteTest
extends ContextTestSupport {
    @Test
    public void testControlBusFail() {
        RouteController routeController = this.context.getRouteController();
        Assertions.assertEquals((Object)"Started", (Object)routeController.getRouteStatus("foo").name());
        this.template.sendBody("direct:foo", (Object)"Hello World");
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).until(() -> routeController.getRouteStatus("foo").isStopped());
        Route route = this.context.getRoute("foo");
        RouteError re = route.getLastError();
        Assertions.assertNotNull((Object)re);
        Assertions.assertTrue((boolean)re.isUnhealthy());
        Assertions.assertEquals((Object)RouteError.Phase.STOP, (Object)re.getPhase());
        Throwable cause = re.getException();
        Assertions.assertNotNull((Object)cause);
        Assertions.assertEquals((Object)"Forced by Donkey Kong", (Object)cause.getMessage());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("controlbus:route?routeId=current&action=fail&async=true"));
                this.from("direct:foo").routeId("foo").throwException((Exception)new IllegalArgumentException("Forced by Donkey Kong"));
            }
        };
    }
}

