/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.browse;

import java.util.Collection;
import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.browse.BrowseEndpoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowseTest
extends ContextTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(BrowseTest.class);
    protected final Object body1 = "one";
    protected final Object body2 = "two";

    @Test
    public void testListEndpoints() throws Exception {
        this.template.sendBody("browse:foo", this.body1);
        this.template.sendBody("browse:foo", this.body2);
        Collection list = this.context.getEndpoints();
        Assertions.assertEquals((int)2, (int)list.size(), (String)"number of endpoints");
        for (Endpoint endpoint : list) {
            List exchanges = ((BrowseEndpoint)endpoint).getExchanges();
            LOG.debug(">>>> {} has: {}", (Object)endpoint, (Object)exchanges);
            Assertions.assertEquals((int)2, (int)exchanges.size(), (String)("Exchanges received on " + String.valueOf(endpoint)));
            BrowseTest.assertInMessageBodyEquals((Exchange)exchanges.get(0), this.body1);
            BrowseTest.assertInMessageBodyEquals((Exchange)exchanges.get(1), this.body2);
        }
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("browse:foo").to("browse:bar");
            }
        };
    }
}

