/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.browse;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.BrowsableEndpoint;
import org.junit.jupiter.api.Test;

public class BrowseRouteConsumeTest
extends ContextTestSupport {
    @Test
    public void testBrowseRoute() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:foo");
        mock.expectedBodiesReceived(new Object[]{"Hello World", "Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        BrowsableEndpoint list = (BrowsableEndpoint)this.context.getEndpoint("browse:foo", BrowsableEndpoint.class);
        ((Exchange)mock.getExchanges().get(0)).equals(list.getExchanges().get(0));
        ((Exchange)mock.getExchanges().get(1)).equals(list.getExchanges().get(1));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").to("browse:foo")).to("mock:result");
                ((RouteDefinition)this.from("browse:foo").to("log:foo")).to("mock:foo");
            }
        };
    }
}

