/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.browse;

import java.util.Collection;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.spi.BrowsableEndpoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BrowseLimitTest
extends ContextTestSupport {
    protected final Object body1 = "one";
    protected final Object body2 = "two";
    protected final Object body3 = "three";
    protected final Object body4 = "four";
    protected final Object body5 = "five";

    @Test
    public void testLimit() throws Exception {
        this.template.sendBody("browse:foo?browseLimit=1", this.body1);
        this.template.sendBody("browse:foo?browseLimit=1", this.body2);
        this.template.sendBody("browse:foo?browseLimit=1", this.body3);
        this.template.sendBody("browse:foo?browseLimit=1", this.body4);
        this.template.sendBody("browse:foo?browseLimit=1", this.body5);
        Collection list = this.context.getEndpoints();
        Assertions.assertEquals((int)2, (int)list.size(), (String)"number of endpoints");
        BrowsableEndpoint be1 = (BrowsableEndpoint)this.context.getEndpoint("browse:foo?browseLimit=1", BrowsableEndpoint.class);
        Assertions.assertEquals((int)1, (int)be1.getExchanges().size());
        Assertions.assertEquals((Object)"five", (Object)((Exchange)be1.getExchanges().get(0)).getMessage().getBody());
        BrowsableEndpoint be2 = (BrowsableEndpoint)this.context.getEndpoint("browse:bar?browseLimit=5", BrowsableEndpoint.class);
        Assertions.assertEquals((int)5, (int)be2.getExchanges().size());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("browse:foo?browseLimit=1").to("browse:bar?browseLimit=5");
            }
        };
    }
}

