/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.browse;

import java.util.Collection;
import java.util.function.Predicate;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.spi.BrowsableEndpoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BrowseFilterTest
extends ContextTestSupport {
    protected final Object body1 = "one";
    protected final Object body2 = "two";
    protected final Object body3 = "three";
    protected final Object body4 = "four";
    protected final Object body5 = "five";

    @Test
    public void testFilter() throws Exception {
        this.template.sendBody("browse:foo", this.body1);
        this.template.sendBody("browse:foo", this.body2);
        this.template.sendBody("browse:foo", this.body3);
        this.template.sendBody("browse:foo", this.body4);
        this.template.sendBody("browse:foo", this.body5);
        Collection list = this.context.getEndpoints();
        Assertions.assertEquals((int)2, (int)list.size(), (String)"number of endpoints");
        BrowsableEndpoint be1 = (BrowsableEndpoint)this.context.getEndpoint("browse:foo", BrowsableEndpoint.class);
        Assertions.assertEquals((int)5, (int)be1.getExchanges().size());
        BrowsableEndpoint be2 = (BrowsableEndpoint)this.context.getEndpoint("browse:bar?filter=#evenFilter", BrowsableEndpoint.class);
        Assertions.assertEquals((int)2, (int)be2.getExchanges().size());
        Assertions.assertEquals((Object)"two", (Object)((Exchange)be2.getExchanges().get(0)).getMessage().getBody());
        Assertions.assertEquals((Object)"four", (Object)((Exchange)be2.getExchanges().get(1)).getMessage().getBody());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                BrowseFilterTest.this.context.getRegistry().bind("evenFilter", (Object)new EvenPredicate());
                this.from("browse:foo").to("browse:bar?filter=#evenFilter");
            }
        };
    }

    private static class EvenPredicate
    implements Predicate<Exchange> {
        private EvenPredicate() {
        }

        @Override
        public boolean test(Exchange exchange) {
            String b = (String)exchange.getMessage().getBody(String.class);
            return "two".equals(b) || "four".equals(b);
        }
    }
}

