/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Test;

public class FilterBeanLanguageNonRegistryTest
extends ContextTestSupport {
    @Test
    public void testBeanLanguageExp() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Camel"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Camel");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                MyBean myBean = new MyBean();
                this.from("direct:start").filter((Predicate)this.method(myBean, "isGoldCustomer")).to("mock:result");
            }
        };
    }

    public static class MyBean {
        public boolean isGoldCustomer(String name) {
            return "Camel".equals(name);
        }
    }
}

