/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.bean.issues.MyLittleBean;
import org.apache.camel.component.bean.issues.MyLittleProcessor;
import org.apache.camel.spi.Registry;
import org.apache.camel.util.StopWatch;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BeanVsProcessorPerformanceTest
extends ContextTestSupport {
    private final int size = 100000;

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("myLittleBean", (Object)new MyLittleBean());
        return jndi;
    }

    @Test
    public void testProcessor() {
        StopWatch watch = new StopWatch();
        for (int i = 0; i < 100000; ++i) {
            Object out = this.template.requestBody("direct:a", (Object)Integer.toString(i));
            Assertions.assertEquals((Object)("Bye " + i), (Object)out);
        }
        this.log.info("Processor took {} ms ", (Object)watch.taken());
    }

    @Test
    public void testBean() {
        StopWatch watch = new StopWatch();
        for (int i = 0; i < 100000; ++i) {
            Object out = this.template.requestBody("direct:b", (Object)Integer.toString(i));
            Assertions.assertEquals((Object)("Bye " + i), (Object)out);
        }
        this.log.info("Bean took {} ms ", (Object)watch.taken());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:a").process((Processor)new MyLittleProcessor());
                this.from("direct:b").bean((Object)"myLittleBean", "bye");
            }
        };
    }
}

