/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.TypeConverter;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.bean.issues.DerivedClass;
import org.apache.camel.component.bean.issues.MyMessage;
import org.apache.camel.component.bean.issues.MyMessageListener;
import org.apache.camel.component.bean.issues.MyMessageToProcessorConverter;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BeanRouteToDerivedClassTest
extends ContextTestSupport {
    private final DerivedClass derived = new DerivedClass();

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testDerivedClassCalled() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to("bean:derived?method=process");
            }
        });
        this.context.start();
        this.template.sendBody("direct:start", (Object)"Hello World");
        Assertions.assertEquals((Object)"Hello World", (Object)this.derived.getAndClearBody(), (String)"Derived class should have been invoked");
    }

    @Test
    public void testDerivedClassCalledWithNoCustomProcessor() throws Exception {
        this.context.getTypeConverterRegistry().addTypeConverter(Processor.class, MyMessageListener.class, (TypeConverter)new MyMessageToProcessorConverter());
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to("bean:derived?method=process");
                this.from("direct:other").to("bean:derived");
            }
        });
        this.context.start();
        Object out = this.template.requestBody("direct:start", (Object)"Hello World");
        Assertions.assertEquals((Object)"Hello World", (Object)this.derived.getAndClearBody(), (String)"Derived class should have been invoked");
        Assertions.assertEquals((Object)"Hello World", (Object)out.toString());
        out = this.template.requestBody("direct:other", (Object)new MyMessage("Hello World"));
        Assertions.assertNull((Object)this.derived.getAndClearBody(), (String)"Derived class should NOT have been invoked");
        Assertions.assertEquals((Object)"Bye World", (Object)out.toString());
        out = this.template.requestBody("direct:other", (Object)new MyMessage("Hello Again"));
        Assertions.assertNull((Object)this.derived.getAndClearBody(), (String)"Derived class should NOT have been invoked");
        Assertions.assertEquals((Object)"Bye World", (Object)out.toString());
    }

    @Test
    public void testDerivedClassCalledWithCustomProcessor() throws Exception {
        this.context.getTypeConverterRegistry().addTypeConverter(Processor.class, MyMessageListener.class, (TypeConverter)new MyMessageToProcessorConverter());
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to("bean:derived?method=process");
                this.from("direct:other").to("bean:derived");
            }
        });
        this.context.start();
        Object out = this.template.requestBody("direct:start", (Object)new MyMessage("Hello World"));
        Assertions.assertEquals((Object)"Hello World", (Object)this.derived.getAndClearBody(), (String)"Derived class should have been invoked");
        Assertions.assertEquals((Object)"Hello World", (Object)out.toString());
        out = this.template.requestBody("direct:other", (Object)new MyMessage("Hello World"));
        Assertions.assertNull((Object)this.derived.getAndClearBody(), (String)"Derived class should NOT have been invoked");
        Assertions.assertEquals((Object)"Bye World", (Object)out.toString());
        out = this.template.requestBody("direct:other", (Object)new MyMessage("Hello Again"));
        Assertions.assertNull((Object)this.derived.getAndClearBody(), (String)"Derived class should NOT have been invoked");
        Assertions.assertEquals((Object)"Bye World", (Object)out.toString());
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("derived", (Object)this.derived);
        return jndi;
    }
}

