/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BeanParameterMatchPerformanceIssueTest
extends ContextTestSupport {
    @Test
    public void testPerformance() {
        String s = (String)this.template.requestBody("direct:a", (Object)"a", String.class);
        Assertions.assertEquals((Object)"Hello slow", (Object)s);
        s = (String)this.template.requestBody("direct:b", (Object)"b", String.class);
        Assertions.assertEquals((Object)"Hello fast", (Object)s);
        s = (String)this.template.requestBody("direct:c", (Object)"c", String.class);
        Assertions.assertEquals((Object)"Hello fast", (Object)s);
        s = (String)this.template.requestBody("direct:d", (Object)"d", String.class);
        Assertions.assertEquals((Object)"Hello 'fast'", (Object)s);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                BeanParameterMatchPerformanceIssueTest.this.context.getRegistry().bind("myBean", (Object)new MyBean());
                this.from("direct:a").to("bean:myBean?method=myMethod(slow)");
                this.from("direct:b").to("bean:myBean?method=myMethod('fast')");
                this.from("direct:c").to("bean:myBean?method=myMethod(\"fast\")");
                this.from("direct:d").to("bean:myBean?method=myMethod(\"'fast'\")");
            }
        };
    }

    private static class MyBean {
        private MyBean() {
        }

        public String myMethod(String str) {
            return "Hello " + str;
        }
    }
}

