/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.bean.issues.ClassA;
import org.apache.camel.component.bean.issues.ClassB;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class BeanParameterBestTypeMatchIssueTest
extends ContextTestSupport {
    @Test
    public void testNoParam() throws InterruptedException {
        this.getMockEndpoint("mock:end").expectedBodiesReceived(new Object[]{"A"});
        this.template.sendBodyAndHeader("direct:noParam", (Object)"body", "key", (Object)"value");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void test1Param() throws InterruptedException {
        this.getMockEndpoint("mock:end").expectedBodiesReceived(new Object[]{"B"});
        this.template.sendBodyAndHeader("direct:1Param", (Object)"body", "key", (Object)"value");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void test2ParamString() throws InterruptedException {
        this.getMockEndpoint("mock:end").expectedBodiesReceived(new Object[]{"C"});
        this.template.sendBodyAndHeader("direct:2Param", (Object)"body", "key", (Object)"value");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void test2ParamClassB() throws InterruptedException {
        this.getMockEndpoint("mock:end").expectedBodiesReceived(new Object[]{"D"});
        this.template.sendBodyAndHeader("direct:2Param", (Object)"body", "key", (Object)new ClassB());
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void test2ParamBoolBody() throws InterruptedException {
        this.getMockEndpoint("mock:end").expectedBodiesReceived(new Object[]{"E"});
        this.template.sendBodyAndHeader("direct:2Param", (Object)true, "key", (Object)"value");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:noParam").bean(ClassA.class, "foo()")).to("mock:end");
                ((RouteDefinition)this.from("direct:1Param").bean(ClassA.class, "foo(${body})")).to("mock:end");
                ((RouteDefinition)this.from("direct:2Param").bean(ClassA.class, "foo(${body}, ${header.key})")).to("mock:end");
            }
        };
    }
}

