/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean.issues;

import java.lang.reflect.Method;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.bean.BeanInfo;
import org.apache.camel.component.bean.MethodInfo;
import org.apache.camel.component.bean.issues.SingleMethodService;
import org.apache.camel.component.bean.issues.SingleMethodServiceImpl;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BeanInfoSingleMethodServiceTest
extends ContextTestSupport {
    private final SingleMethodService<String, String> myService = new SingleMethodServiceImpl();

    @Test
    public void testBeanInfoSingleMethodRoute() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"You said Hello World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testBeanInfoSingleMethod() {
        BeanInfo beaninfo = new BeanInfo((CamelContext)this.context, SingleMethodService.class);
        Assertions.assertEquals((int)1, (int)beaninfo.getMethods().size());
        Assertions.assertEquals((Object)"doSomething", (Object)((MethodInfo)beaninfo.getMethods().get(0)).getMethod().getName());
    }

    @Test
    public void testBeanInfoSingleMethodImpl() throws Exception {
        BeanInfo beaninfo = new BeanInfo((CamelContext)this.context, SingleMethodServiceImpl.class);
        Assertions.assertEquals((int)2, (int)beaninfo.getMethods().size());
        Assertions.assertEquals((Object)"doSomething", (Object)((MethodInfo)beaninfo.getMethods().get(0)).getMethod().getName());
        Assertions.assertEquals((Object)"hello", (Object)((MethodInfo)beaninfo.getMethods().get(1)).getMethod().getName());
        Method method = ((MethodInfo)beaninfo.getMethods().get(0)).getMethod();
        Object out = method.invoke(this.myService, "Bye World");
        Assertions.assertEquals((Object)"You said Bye World", (Object)out);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").bean(BeanInfoSingleMethodServiceTest.this.myService, "doSomething")).to("mock:result");
            }
        };
    }
}

