/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.SimpleRegistry;
import org.junit.jupiter.api.Test;

public class SimpleLanguageBeanFunctionScopeTest
extends ContextTestSupport {
    @Test
    public void testSingleton() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"A", "B"});
        this.getMockEndpoint("mock:other").expectedBodiesReceived(new Object[]{"C"});
        this.template.sendBody("direct:single", (Object)"A");
        this.template.sendBody("direct:single", (Object)"B");
        this.template.sendBody("direct:single", (Object)"C");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testPrototype() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"A", "B", "C"});
        this.template.sendBody("direct:proto", (Object)"A");
        this.template.sendBody("direct:proto", (Object)"B");
        this.template.sendBody("direct:proto", (Object)"C");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testRequest() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"A", "A", "B", "B", "C", "C"});
        this.getMockEndpoint("mock:other").expectedBodiesReceived(new Object[]{"A", "B", "C"});
        this.template.sendBody("direct:request", (Object)"A");
        this.template.sendBody("direct:request", (Object)"B");
        this.template.sendBody("direct:request", (Object)"C");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected Registry createCamelRegistry() {
        SimpleRegistry wrapper = new SimpleRegistry(){

            public Object lookupByName(String name) {
                if ("foo".equals(name)) {
                    return new MyBean();
                }
                return super.lookupByName(name);
            }
        };
        return wrapper;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ChoiceDefinition)((ChoiceDefinition)this.from("direct:single").choice().when().simple("${bean:foo?scope=Singleton}")).to("mock:result")).otherwise().to("mock:other");
                ((ChoiceDefinition)((ChoiceDefinition)this.from("direct:proto").choice().when().simple("${bean:foo?scope=Prototype}")).to("mock:result")).otherwise().to("mock:other");
                ((RouteDefinition)((RouteDefinition)this.from("direct:request").to("direct:sub")).to("direct:sub")).to("direct:sub");
                ((ChoiceDefinition)((ChoiceDefinition)this.from("direct:sub").choice().when().simple("${bean:foo?scope=Request}")).to("mock:result")).otherwise().to("mock:other");
            }
        };
    }

    public static class MyBean {
        private int counter;

        public boolean bar(String body) {
            return ++this.counter < 3;
        }
    }
}

