/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.bean.ProxyHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ProxyReturnFutureTest
extends ContextTestSupport {
    @Test
    public void testFutureEcho() throws Exception {
        Echo service = (Echo)ProxyHelper.createProxy((Endpoint)this.context.getEndpoint("direct:echo"), Echo.class);
        Future<String> future = service.asText(4);
        this.log.info("Got future");
        this.log.info("Waiting for future to be done ...");
        String reply = future.get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)"Four", (Object)reply);
    }

    @Test
    public void testFutureEchoCallTwoTimes() throws Exception {
        Echo service = (Echo)ProxyHelper.createProxy((Endpoint)this.context.getEndpoint("direct:echo"), Echo.class);
        Future<String> future = service.asText(4);
        this.log.info("Got future");
        this.log.info("Waiting for future to be done ...");
        Assertions.assertEquals((Object)"Four", (Object)future.get(5L, TimeUnit.SECONDS));
        future = service.asText(5);
        this.log.info("Got future");
        this.log.info("Waiting for future to be done ...");
        Assertions.assertEquals((Object)"Four", (Object)future.get(5L, TimeUnit.SECONDS));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:echo").delay(250L).transform().constant((Object)"Four");
            }
        };
    }

    public static interface Echo {
        public Future<String> asText(int var1);
    }
}

