/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.bean.ProxyHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ProxyReturnFutureExceptionTest
extends ContextTestSupport {
    @Test
    public void testFutureEchoException() throws Exception {
        Echo service = (Echo)ProxyHelper.createProxy((Endpoint)this.context.getEndpoint("direct:echo"), Echo.class);
        Future<String> future = service.asText(4);
        this.log.info("Got future");
        this.log.info("Waiting for future to be done ...");
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> Assertions.assertEquals((Object)"Four", future.get(5L, TimeUnit.SECONDS)), (String)"Should have thrown exception");
        IllegalArgumentException cause = ProxyReturnFutureExceptionTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
        Assertions.assertEquals((Object)"Forced", (Object)cause.getMessage());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:echo").delay(250L).throwException((Exception)new IllegalArgumentException("Forced"));
            }
        };
    }

    public static interface Echo {
        public Future<String> asText(int var1);
    }
}

