/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PredicateAsBeanTest
extends ContextTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(PredicateAsBeanTest.class);
    protected final MyPredicate myPredicate = new MyPredicate();

    @Test
    public void testSendMessage() {
        String expectedBody = "Wobble";
        this.template.sendBodyAndHeader("direct:in", (Object)expectedBody, "foo", (Object)"bar");
        Assertions.assertEquals((Object)expectedBody, (Object)this.myPredicate.body, (String)("bean body: " + String.valueOf(this.myPredicate)));
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry answer = super.createCamelRegistry();
        answer.bind("myPredicate", (Object)this.myPredicate);
        return answer;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:in").to("bean:myPredicate");
            }
        };
    }

    public static class MyPredicate
    implements Predicate {
        public String body;

        public boolean matches(Exchange exchange) {
            LOG.info("matches(exchange) called with: {}", (Object)exchange);
            this.body = (String)exchange.getIn().getBody(String.class);
            return null != this.body && this.body.equals("Wobble");
        }
    }
}

