/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.bean.MyApplicationException;
import org.apache.camel.component.bean.MyCustomException;
import org.apache.camel.component.bean.MyRequest;
import org.apache.camel.component.bean.MyResponse;
import org.apache.camel.component.bean.MyService;
import org.apache.camel.component.bean.ProxyHelper;
import org.apache.camel.model.ChoiceDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MyServiceProxyTest
extends ContextTestSupport {
    @Test
    public void testOk() throws Exception {
        MyService myService = (MyService)ProxyHelper.createProxy((Endpoint)this.context.getEndpoint("direct:start"), MyService.class);
        String reply = myService.method("Hello World");
        Assertions.assertEquals((Object)"Camel in Action", (Object)reply);
    }

    @Test
    public void testKaboom() throws Exception {
        MyService myService = (MyService)ProxyHelper.createProxy((Endpoint)this.context.getEndpoint("direct:start"), MyService.class);
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> myService.method("Kaboom"), (String)"Should have thrown exception");
        Assertions.assertEquals((Object)"Damn", (Object)e.getMessage());
    }

    @Test
    public void testCheckedException() throws Exception {
        MyService myService = (MyService)ProxyHelper.createProxy((Endpoint)this.context.getEndpoint("direct:start"), MyService.class);
        MyApplicationException e = (MyApplicationException)Assertions.assertThrows(MyApplicationException.class, () -> myService.method("Tiger in Action"), (String)"Should have thrown exception");
        Assertions.assertEquals((Object)"No tigers", (Object)e.getMessage());
        Assertions.assertEquals((int)9, (int)e.getCode());
    }

    @Test
    public void testNestedRuntimeCheckedException() throws Exception {
        MyService myService = (MyService)ProxyHelper.createProxy((Endpoint)this.context.getEndpoint("direct:start"), MyService.class);
        MyApplicationException e = (MyApplicationException)Assertions.assertThrows(MyApplicationException.class, () -> myService.method("Donkey in Action"), (String)"Should have thrown exception");
        Assertions.assertEquals((Object)"No donkeys", (Object)e.getMessage());
        Assertions.assertEquals((int)8, (int)e.getCode());
    }

    @Test
    public void testNestedCheckedCheckedException() throws Exception {
        MyService myService = (MyService)ProxyHelper.createProxy((Endpoint)this.context.getEndpoint("direct:start"), MyService.class);
        MyApplicationException e = (MyApplicationException)Assertions.assertThrows(MyApplicationException.class, () -> myService.method("Elephant in Action"), (String)"Should have thrown exception");
        Assertions.assertEquals((Object)"No elephants", (Object)e.getMessage());
        Assertions.assertEquals((int)7, (int)e.getCode());
    }

    @Test
    public void testRequestAndResponse() throws Exception {
        MyService myService = (MyService)ProxyHelper.createProxy((Endpoint)this.context.getEndpoint("direct:request"), MyService.class);
        MyRequest in = new MyRequest();
        in.id = 100;
        in.request = "Camel";
        MyResponse response = myService.call(in);
        Assertions.assertEquals((int)100, (int)response.id, (String)"Get a wrong response id.");
        Assertions.assertEquals((Object)"Hi Camel", (Object)response.response, (String)"Get a wrong response");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").choice().when(this.body().isEqualTo((Object)"Tiger in Action")).throwException((Exception)new MyApplicationException("No tigers", 9))).when(this.body().isEqualTo((Object)"Donkey in Action")).throwException((Exception)((Object)new RuntimeCamelException((Throwable)new MyApplicationException("No donkeys", 8))))).when(this.body().isEqualTo((Object)"Elephant in Action")).throwException((Exception)new MyCustomException("Damn", new MyApplicationException("No elephants", 7)))).when(this.body().isEqualTo((Object)"Kaboom")).throwException((Exception)new IllegalArgumentException("Damn"))).otherwise().transform((Expression)this.constant("Camel in Action"));
                this.from("direct:request").process(new Processor(){

                    public void process(Exchange exchange) {
                        MyRequest request = (MyRequest)exchange.getIn().getBody(MyRequest.class);
                        MyResponse response = new MyResponse();
                        response.id = request.id;
                        response.response = "Hi " + request.request;
                        exchange.getMessage().setBody((Object)response);
                    }
                });
            }
        };
    }
}

