/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.bean.MyFooBean;
import org.apache.camel.model.FilterDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Test;

public class MethodCallRefOrBeanPrefixPredicateTest
extends ContextTestSupport {
    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("foo", (Object)new MyFooBean());
        return jndi;
    }

    @Test
    public void testRefOrBeanPrefix() throws Exception {
        this.getMockEndpoint("mock:a").expectedBodiesReceived(new Object[]{"A"});
        this.getMockEndpoint("mock:b").expectedBodiesReceived(new Object[]{"B"});
        this.template.sendBody("direct:a", (Object)"A");
        this.template.sendBody("direct:b", (Object)"B");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((FilterDefinition)this.from("direct:a").filter().method("ref:foo")).to("mock:a");
                ((FilterDefinition)this.from("direct:b").filter().method("bean:foo")).to("mock:b");
            }
        };
    }
}

