/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ProcessorDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MethodCallMissingParenthesisTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testCorrect() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((ProcessorDefinition)this.from("direct:start").transform().method(MethodCallMissingParenthesisTest.class, "doSomething(${body}, ${header.foo})")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello=Camel"});
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello", "foo", (Object)"Camel");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testMissing() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((ProcessorDefinition)this.from("direct:start").transform().method(MethodCallMissingParenthesisTest.class, "doSomething(${body}, ${header.foo}")).to("mock:result");
            }
        });
        this.context.start();
        CamelExecutionException e = (CamelExecutionException)Assertions.assertThrows(CamelExecutionException.class, () -> this.template.sendBodyAndHeader("direct:start", (Object)"Hello", "foo", (Object)"Camel"), (String)"Method should end with parenthesis, was doSomething(${body}, ${header.foo}");
        IllegalArgumentException iae = MethodCallMissingParenthesisTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause().getCause());
        Assertions.assertEquals((Object)"Method should end with parenthesis, was doSomething(${body}, ${header.foo}", (Object)iae.getMessage());
    }

    @Test
    public void testInvalidName() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((ProcessorDefinition)this.from("direct:start").transform().method(MethodCallMissingParenthesisTest.class, "--doSomething(${body}, ${header.foo})")).to("mock:result");
            }
        });
        this.context.start();
        CamelExecutionException e = (CamelExecutionException)Assertions.assertThrows(CamelExecutionException.class, () -> this.template.sendBodyAndHeader("direct:start", (Object)"Hello", "foo", (Object)"Camel"), (String)"Should throw exception");
        IllegalArgumentException iae = MethodCallMissingParenthesisTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause().getCause());
        Assertions.assertEquals((Object)"Method name must start with a valid java identifier at position: 0 in method: --doSomething(${body}, ${header.foo})", (Object)iae.getMessage());
    }

    public String doSomething(String body, String header) {
        return body + "=" + header;
    }
}

