/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Handler;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Test;

public class MethodCallByTypeRefExistingBeanTest
extends ContextTestSupport {
    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("foo", (Object)new MyBean("Type Ref "));
        return jndi;
    }

    @Test
    public void testRefOrBeanPrefix() throws Exception {
        this.getMockEndpoint("mock:a").expectedBodiesReceived(new Object[]{"Hello Type Ref A"});
        this.getMockEndpoint("mock:b").expectedBodiesReceived(new Object[]{"Hello Type Ref B"});
        this.template.sendBody("direct:a", (Object)"A");
        this.template.sendBody("direct:b", (Object)"B");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ProcessorDefinition)this.from("direct:a").transform().method(MyBean.class)).to("mock:a");
                ((ProcessorDefinition)this.from("direct:b").transform().method(MyBean.class)).to("mock:b");
            }
        };
    }

    private static class MyBean {
        private final String field;

        public MyBean(String field) {
            this.field = field;
        }

        @Handler
        public String hello(String text) {
            return "Hello " + this.field + text;
        }
    }
}

