/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.util.UUID;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Header;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileBeanParameterBindingTest
extends ContextTestSupport {
    private static final String TEST_FILE_NAME = "hello." + String.valueOf(UUID.randomUUID()) + ".txt";

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("foo", (Object)new MyFooBean());
        return jndi;
    }

    @Test
    public void testFileToBean() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from(FileBeanParameterBindingTest.this.fileUri()).to("bean:foo?method=before")).process(new Processor(){

                    public void process(Exchange exchange) {
                        exchange.getIn().setHeader("bar", (Object)123);
                    }
                })).to("bean:foo?method=after")).to("mock:result");
            }
        };
    }

    public static class MyFooBean {
        public void before(@Header(value="bar") Integer bar, @Header(value="CamelFileName") String name) {
            Assertions.assertNull((Object)bar, (String)"There should be no bar");
            Assertions.assertEquals((Object)TEST_FILE_NAME, (Object)name);
        }

        public void after(@Header(value="bar") Integer bar, @Header(value="CamelFileName") String name) {
            Assertions.assertNotNull((Object)bar, (String)"There should be bar");
            Assertions.assertEquals((int)123, (int)bar);
            Assertions.assertEquals((Object)TEST_FILE_NAME, (Object)name);
        }
    }
}

