/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Handler;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.language.simple.Simple;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionAnnotationToDisambiguateMethodsTest
extends ContextTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ExpressionAnnotationToDisambiguateMethodsTest.class);
    protected final MyBean myBean = new MyBean();
    protected final MyOtherBean myOtherBean = new MyOtherBean();

    @Test
    public void testSendMessage() {
        this.template.sendBodyAndHeader("direct:in", (Object)"<hello>world!</hello>", "foo", (Object)"bar");
        Assertions.assertEquals((Object)"bar", (Object)this.myBean.bar, (String)("bean body: " + String.valueOf(this.myBean)));
    }

    @Test
    public void testSendMessageHandler() {
        this.template.sendBodyAndHeader("direct:other", (Object)"<hello>world!</hello>", "foo", (Object)"bar");
        Assertions.assertEquals((Object)"bar", (Object)this.myOtherBean.bar, (String)("bean body: " + String.valueOf(this.myOtherBean)));
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry answer = super.createCamelRegistry();
        answer.bind("myBean", (Object)this.myBean);
        answer.bind("myOtherBean", (Object)this.myOtherBean);
        return answer;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:in").bean((Object)"myBean");
                this.from("direct:other").bean((Object)"myOtherBean");
            }
        };
    }

    public static class MyBean {
        public String bar;

        public void bar(String body) {
            Assertions.fail((String)("bar() called with: " + body));
        }

        public void foo(@Simple(value="${header.foo}") String bar) {
            this.bar = bar;
            LOG.info("foo() method called with: {}", (Object)bar);
        }

        public void wrongMethod(String body) {
            Assertions.fail((String)("wrongMethod() called with: " + body));
        }
    }

    public static class MyOtherBean {
        public String bar;

        public void bar(String body) {
            Assertions.fail((String)("bar() called with: " + body));
        }

        @Handler
        public void foo(@Simple(value="${header.foo}") String bar) {
            this.bar = bar;
            LOG.info("foo() method called with: {}", (Object)bar);
        }

        public void wrongMethod(String body) {
            Assertions.fail((String)("wrongMethod() called with: " + body));
        }
    }
}

