/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.TypeConverter;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultParameterMappingStrategyTest
extends ContextTestSupport {
    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("foo", (Object)new MyFooBean());
        return jndi;
    }

    @Test
    public void testExchange() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Exchange"});
        this.template.sendBody("direct:a", (Object)"Hello");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testMessage() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Message"});
        this.template.sendBody("direct:b", (Object)"Hello");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testException() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Exception"});
        this.template.send("direct:c", new Processor(){

            public void process(Exchange exchange) {
                exchange.getIn().setBody((Object)"Hello");
                exchange.setException((Throwable)new IllegalArgumentException("Forced by unit test"));
            }
        });
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testTypeConverter() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"TypeConverter"});
        this.template.sendBody("direct:d", (Object)"Hello");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testRegistry() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Registry"});
        this.template.sendBody("direct:e", (Object)"Hello");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testCamelContext() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"CamelContext"});
        this.template.sendBody("direct:f", (Object)"Hello");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:error").logStackTrace(false).disableRedelivery());
                ((OnExceptionDefinition)this.onException(Exception.class).handled(true).bean((Object)"foo", "withException")).to("mock:result");
                ((RouteDefinition)this.from("direct:a").bean((Object)"foo", "withExchange")).to("mock:result");
                ((RouteDefinition)this.from("direct:b").bean((Object)"foo", "withMessage")).to("mock:result");
                this.from("direct:c").to("mock:foo");
                ((RouteDefinition)this.from("direct:d").bean((Object)"foo", "withTypeConverter")).to("mock:result");
                ((RouteDefinition)this.from("direct:e").bean((Object)"foo", "withRegistry")).to("mock:result");
                ((RouteDefinition)this.from("direct:f").bean((Object)"foo", "withCamelContext")).to("mock:result");
            }
        };
    }

    public static class MyFooBean {
        public String withExchange(Exchange exchange) {
            Assertions.assertNotNull((Object)exchange);
            Assertions.assertEquals((Object)"Hello", (Object)exchange.getIn().getBody(String.class));
            return "Exchange";
        }

        public String withMessage(Message message) {
            Assertions.assertNotNull((Object)message);
            Assertions.assertEquals((Object)"Hello", (Object)message.getBody(String.class));
            return "Message";
        }

        public String withException(Message in, Exception cause) {
            Assertions.assertNotNull((Object)in);
            Assertions.assertNotNull((Object)cause);
            Assertions.assertEquals((Object)"Hello", (Object)in.getBody(String.class));
            return "Exception";
        }

        public String withTypeConverter(String body, TypeConverter converter) {
            Assertions.assertNotNull((Object)body);
            Assertions.assertNotNull((Object)converter);
            Assertions.assertEquals((Object)"Hello", (Object)body);
            Assertions.assertEquals((Integer)123, (Integer)((Integer)converter.convertTo(Integer.class, (Object)"123")));
            return "TypeConverter";
        }

        public String withRegistry(String body, Registry registry) {
            Assertions.assertNotNull((Object)body);
            Assertions.assertNotNull((Object)registry);
            Assertions.assertNotNull((Object)registry.lookupByName("foo"));
            Assertions.assertEquals((Object)"Hello", (Object)body);
            return "Registry";
        }

        public String withCamelContext(String body, CamelContext camel) {
            Assertions.assertNotNull((Object)body);
            Assertions.assertNotNull((Object)camel);
            Assertions.assertNotNull((Object)camel.getRegistry().lookupByName("foo"));
            Assertions.assertEquals((Object)"Hello", (Object)body);
            return "CamelContext";
        }
    }
}

