/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.bean.ParameterMappingStrategy;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.ExpressionAdapter;
import org.junit.jupiter.api.Test;

public class CustomParameterMappingStrategyTest
extends ContextTestSupport {
    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("foo", (Object)new MyFooBean());
        jndi.bind("myStrategy", (Object)new MyCustomStrategy());
        return jndi;
    }

    @Test
    public void testExchange() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"You said: Hello Claus"});
        this.template.sendBody("direct:a", (Object)"Claus");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:a").bean((Object)"foo")).to("mock:result");
            }
        };
    }

    public static class MyFooBean {
        public String cheese(String body) {
            return "You said: " + body;
        }
    }

    public static class MyCustomStrategy
    implements ParameterMappingStrategy {
        public Expression getDefaultParameterTypeExpression(Class<?> parameterType) {
            if (String.class.isAssignableFrom(parameterType)) {
                return new ExpressionAdapter(){

                    public Object evaluate(Exchange exchange) {
                        return "Hello " + (String)exchange.getIn().getBody(String.class);
                    }
                };
            }
            return null;
        }
    }
}

