/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ClassComponentInvalidConfigurationTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testClassNotFound() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").to("class:org.apache.camel.component.bean.XXX")).to("mock:result");
            }
        });
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> this.context.start(), (String)"Should have thrown exception");
        ResolveEndpointFailedException cause = ClassComponentInvalidConfigurationTest.assertIsInstanceOf(ResolveEndpointFailedException.class, e.getCause());
        ClassNotFoundException not = ClassComponentInvalidConfigurationTest.assertIsInstanceOf(ClassNotFoundException.class, cause.getCause());
        Assertions.assertEquals((Object)"org.apache.camel.component.bean.XXX", (Object)not.getMessage());
    }

    @Test
    public void testPropertyNotFoundOnClass() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").to("class:org.apache.camel.component.bean.MyPrefixBean?bean.foo=bar")).to("mock:result");
            }
        });
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> this.context.start(), (String)"Should have thrown exception");
        ResolveEndpointFailedException cause = ClassComponentInvalidConfigurationTest.assertIsInstanceOf(ResolveEndpointFailedException.class, e.getCause());
        Assertions.assertTrue((boolean)cause.getMessage().contains("Unknown parameters"));
        Assertions.assertTrue((boolean)cause.getMessage().contains("foo=bar"));
    }
}

