/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.Body;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BodyAnnotationToDisambiguateMethodsTest
extends ContextTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(BodyAnnotationToDisambiguateMethodsTest.class);
    protected final MyBean myBean = new MyBean();

    @Test
    public void testSendMessage() {
        String expectedBody = "Wobble";
        this.template.sendBodyAndHeader("direct:in", (Object)expectedBody, "foo", (Object)"bar");
        Assertions.assertEquals((Object)expectedBody, (Object)this.myBean.body, (String)("bean body: " + String.valueOf(this.myBean)));
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry answer = super.createCamelRegistry();
        answer.bind("myBean", (Object)this.myBean);
        return answer;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:in").bean((Object)"myBean");
            }
        };
    }

    public static class MyBean {
        public String body;

        public void bar(String body) {
            Assertions.fail((String)("bar() called with: " + body));
        }

        public void foo(@Body String body) {
            this.body = body;
            LOG.info("foo() method called on {}", (Object)this);
        }

        public void wrongMethod(String body) {
            Assertions.fail((String)("wrongMethod() called with: {}" + body));
        }
    }
}

