/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Handler;
import org.apache.camel.language.xpath.XPath;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BeanWithXPathInjectionUsingHeaderValueTest
extends ContextTestSupport {
    protected final MyBean myBean = new MyBean();

    @Test
    public void testConstantXPathHeaders() {
        this.template.sendBodyAndHeader("bean:myBean", (Object)"<response>OK</response>", "invoiceDetails", (Object)"<invoice><person><name>Alan</name><date>26/08/2012</date></person></invoice>");
        Assertions.assertEquals((Object)"OK", (Object)this.myBean.response, (String)("bean response:  " + String.valueOf(this.myBean)));
        Assertions.assertEquals((Object)"Alan", (Object)this.myBean.userName, (String)("bean userName: " + String.valueOf(this.myBean)));
        Assertions.assertEquals((Object)"26/08/2012", (Object)this.myBean.date, (String)("bean date:  " + String.valueOf(this.myBean)));
        this.template.sendBodyAndHeader("bean:myBean", (Object)"<response>OK</response>", "invoiceDetails", (Object)"<invoice><person><name>Jack</name><date>27/08/2012</date></person></invoice>");
        Assertions.assertEquals((Object)"OK", (Object)this.myBean.response, (String)("bean response:  " + String.valueOf(this.myBean)));
        Assertions.assertEquals((Object)"Jack", (Object)this.myBean.userName, (String)("bean userName: " + String.valueOf(this.myBean)));
        Assertions.assertEquals((Object)"27/08/2012", (Object)this.myBean.date, (String)("bean date:  " + String.valueOf(this.myBean)));
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry answer = super.createCamelRegistry();
        answer.bind("myBean", (Object)this.myBean);
        return answer;
    }

    public static class MyBean {
        public String userName;
        public String date;
        public String response;

        @Handler
        public void handler(@XPath(value="//response/text()") String response, @XPath(source="header:invoiceDetails", value="//invoice/person/name/text()") String userName, @XPath(source="header:invoiceDetails", value="//invoice/person/date", resultType=String.class) String date) {
            this.response = response;
            this.userName = userName;
            this.date = date;
        }
    }
}

