/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.util.Map;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Variables;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanWithVariablesAndBodyInjectionTest
extends ContextTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(BeanWithVariablesAndBodyInjectionTest.class);
    protected final MyBean myBean = new MyBean();

    @Test
    public void testSendMessage() {
        this.template.send("direct:in", new Processor(){

            public void process(Exchange exchange) {
                exchange.setProperty("p1", (Object)"abc");
                exchange.setProperty("p2", (Object)123);
                Message in = exchange.getIn();
                exchange.setVariable("h1", (Object)"xyz");
                exchange.setVariable("h2", (Object)456);
                in.setBody((Object)"TheBody");
            }
        });
        Map<String, Object> foo = this.myBean.variables;
        Assertions.assertNotNull(foo, (String)"myBean.foo");
        Assertions.assertEquals((Object)"xyz", (Object)foo.get("h1"), (String)"foo.h1");
        Assertions.assertEquals((Object)456, (Object)foo.get("h2"), (String)"foo.h2");
        Assertions.assertEquals((Object)"TheBody", (Object)this.myBean.body, (String)"body");
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry answer = super.createCamelRegistry();
        answer.bind("myBean", (Object)this.myBean);
        return answer;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:in").to("bean:myBean?method=myMethod");
            }
        };
    }

    public static class MyBean {
        public Map<String, Object> variables;
        public Object body;

        public String toString() {
            return "MyBean[foo: " + String.valueOf(this.variables) + " body: " + String.valueOf(this.body) + "]";
        }

        public void myMethod(@Variables Map<String, Object> variables, Object body) {
            this.variables = variables;
            this.body = body;
            LOG.info("myMethod() method called on {}", (Object)this);
        }

        public void anotherMethod(@Variables Map<String, Object> variables, Object body) {
            Assertions.fail((String)"Should not have called this method!");
        }
    }
}

