/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.util.Map;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangeProperties;
import org.apache.camel.Headers;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanWithPropertiesAndHeadersInjectionTest
extends ContextTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(BeanWithPropertiesAndHeadersInjectionTest.class);
    protected final MyBean myBean = new MyBean();

    @Test
    public void testSendMessage() {
        this.template.send("direct:in", new Processor(){

            public void process(Exchange exchange) {
                exchange.setProperty("p1", (Object)"abc");
                exchange.setProperty("p2", (Object)123);
                Message in = exchange.getIn();
                in.setHeader("h1", (Object)"xyz");
                in.setHeader("h2", (Object)456);
            }
        });
        Map<?, ?> foo = this.myBean.foo;
        Map<?, ?> bar = this.myBean.bar;
        Assertions.assertNotNull(foo, (String)"myBean.foo");
        Assertions.assertNotNull(bar, (String)"myBean.bar");
        Assertions.assertEquals((Object)"abc", foo.get("p1"), (String)"foo.p1");
        Assertions.assertEquals((Object)123, foo.get("p2"), (String)"foo.p2");
        Assertions.assertEquals((Object)"xyz", bar.get("h1"), (String)"bar.h1");
        Assertions.assertEquals((Object)456, bar.get("h2"), (String)"bar.h2");
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry answer = super.createCamelRegistry();
        answer.bind("myBean", (Object)this.myBean);
        return answer;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:in").bean((Object)"myBean");
            }
        };
    }

    public static class MyBean {
        public Map<?, ?> foo;
        public Map<?, ?> bar;

        public String toString() {
            return "MyBean[foo: " + String.valueOf(this.foo) + " bar: " + String.valueOf(this.bar) + "]";
        }

        public void myMethod(@ExchangeProperties Map<?, ?> foo, @Headers Map<?, ?> bar) {
            this.foo = foo;
            this.bar = bar;
            LOG.info("myMethod() method called on {}", (Object)this);
        }
    }
}

