/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.bean.AmbiguousMethodCallException;
import org.apache.camel.component.bean.MethodNotFoundException;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BeanWithMethodHeaderTest
extends ContextTestSupport {
    private MyBean bean;

    @Test
    public void testEcho() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"echo Hello World"});
        this.template.sendBody("direct:echo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testHi() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"hi Hello World"});
        this.template.sendBody("direct:hi", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testFail() {
        CamelExecutionException e = (CamelExecutionException)Assertions.assertThrows(CamelExecutionException.class, () -> this.template.sendBody("direct:fail", (Object)"Hello World"), (String)"Should throw an exception");
        BeanWithMethodHeaderTest.assertIsInstanceOf(AmbiguousMethodCallException.class, e.getCause());
        AmbiguousMethodCallException ace = (AmbiguousMethodCallException)e.getCause();
        Assertions.assertEquals((int)2, (int)ace.getMethods().size());
    }

    @Test
    public void testMethodNotExists() {
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:typo").bean((Object)"myBean", "ups")).to("mock:result");
            }
        }), (String)"Should throw an exception");
        MethodNotFoundException mnfe = BeanWithMethodHeaderTest.assertIsInstanceOf(MethodNotFoundException.class, e.getCause());
        Assertions.assertEquals((Object)"ups", (Object)mnfe.getMethodName());
        Assertions.assertSame((Object)this.bean, (Object)mnfe.getBean());
    }

    @Test
    public void testMethodNotExistsOnInstance() {
        final MyBean myBean = new MyBean();
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:typo").bean((Object)myBean, "ups")).to("mock:result");
            }
        }), (String)"Should throw an exception");
        MethodNotFoundException mnfe = BeanWithMethodHeaderTest.assertIsInstanceOf(MethodNotFoundException.class, e.getCause());
        Assertions.assertEquals((Object)"ups", (Object)mnfe.getMethodName());
        Assertions.assertSame((Object)myBean, (Object)mnfe.getBean());
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry answer = super.createCamelRegistry();
        this.bean = new MyBean();
        answer.bind("myBean", (Object)this.bean);
        return answer;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:echo").bean((Object)"myBean", "echo")).to("mock:result");
                ((RouteDefinition)this.from("direct:hi").bean((Object)"myBean", "hi")).to("mock:result");
                ((RouteDefinition)this.from("direct:fail").bean((Object)"myBean")).to("mock:result");
            }
        };
    }

    public static class MyBean {
        public String hi(String s) {
            return "hi " + s;
        }

        public String echo(String s) {
            return "echo " + s;
        }
    }
}

