/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.util.Map;
import org.apache.camel.Body;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Headers;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BeanWithHeadersAndBodyInject3Test
extends ContextTestSupport {
    private final MyBean myBean = new MyBean();

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").to("bean:myBean?method=doSomething")).to("mock:finish");
            }
        };
    }

    @Test
    public void testInOnly() throws Exception {
        MockEndpoint end = this.getMockEndpoint("mock:finish");
        end.expectedBodiesReceived(new Object[]{"Hello!"});
        this.sendBody("direct:start", "Test Input");
        this.assertMockEndpointsSatisfied();
        Assertions.assertNotNull((Object)((Exchange)end.getExchanges().get(0)).getIn().getBody());
        Assertions.assertEquals((Object)"Hello!", (Object)((Exchange)end.getExchanges().get(0)).getIn().getBody());
    }

    @Test
    public void testInOut() throws Exception {
        MockEndpoint end = this.getMockEndpoint("mock:finish");
        end.expectedBodiesReceived(new Object[]{"Hello!"});
        end.expectedHeaderReceived("out", (Object)123);
        String out = (String)this.template.requestBody("direct:start", (Object)"Test Input", String.class);
        Assertions.assertEquals((Object)"Hello!", (Object)out);
        this.assertMockEndpointsSatisfied();
        Assertions.assertNotNull((Object)((Exchange)end.getExchanges().get(0)).getIn().getBody());
        Assertions.assertEquals((Object)"Hello!", (Object)((Exchange)end.getExchanges().get(0)).getIn().getBody());
        Assertions.assertEquals((Object)123, (Object)((Exchange)end.getExchanges().get(0)).getIn().getHeader("out"));
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry answer = super.createCamelRegistry();
        answer.bind("myBean", (Object)this.myBean);
        return answer;
    }

    public static class MyBean {
        public String doSomething(@Body String body, @Headers Map<String, Object> headers) {
            headers.put("out", 123);
            return "Hello!";
        }
    }
}

