/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Header;
import org.apache.camel.Message;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanWithHeadersAndBodyInject2Test
extends ContextTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(BeanWithHeadersAndBodyInject2Test.class);
    private final MyBean myBean = new MyBean();
    private final Map<String, User> users = new HashMap<String, User>();

    @Test
    public void testCannotBindToParameter() {
        this.users.put("charles", new User("Charles", "43"));
        this.users.put("claus", new User("Claus", "33"));
        Exchange out = this.template.send("direct:in", new Processor(){

            public void process(Exchange exchange) {
                exchange.setProperty("p1", (Object)"abc");
                exchange.setProperty("p2", (Object)123);
                Message in = exchange.getIn();
                in.setHeader("users", BeanWithHeadersAndBodyInject2Test.this.users);
                in.setBody((Object)"TheBody");
            }
        });
        Assertions.assertTrue((boolean)out.isFailed(), (String)"Should fail");
        BeanWithHeadersAndBodyInject2Test.assertIsInstanceOf(RuntimeCamelException.class, out.getException());
        BeanWithHeadersAndBodyInject2Test.assertIsInstanceOf(NoTypeConversionAvailableException.class, out.getException().getCause());
    }

    @Test
    public void testBindToParameter() {
        final ArrayList<String> list = new ArrayList<String>();
        list.add("Charles");
        list.add("Claus");
        Exchange out = this.template.send("direct:in", new Processor(){

            public void process(Exchange exchange) {
                exchange.getIn().setBody((Object)"TheBody");
                exchange.getIn().setHeader("users", (Object)list);
            }
        });
        Assertions.assertFalse((boolean)out.isFailed(), (String)"Should not fail");
        Assertions.assertSame(list, this.myBean.users);
        Assertions.assertEquals((Object)"TheBody", (Object)this.myBean.body);
    }

    @Test
    public void testBindToParameterIsNullValue() {
        Exchange out = this.template.send("direct:in", new Processor(){

            public void process(Exchange exchange) {
                exchange.getIn().setBody((Object)"TheBody");
                exchange.getIn().setHeader("users", null);
            }
        });
        Assertions.assertFalse((boolean)out.isFailed(), (String)"Should not fail");
        Assertions.assertEquals((Object)"TheBody", (Object)this.myBean.body);
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry answer = super.createCamelRegistry();
        answer.bind("myBean", (Object)this.myBean);
        return answer;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:in").to("bean:myBean?method=myMethod");
            }
        };
    }

    public static class MyBean {
        public Object body;
        public List<User> users;

        public void myMethod(@Header(value="users") List<User> users, Object body) {
            LOG.info("myMethod() method called on {}", (Object)this);
            LOG.info(" users {}", users);
            this.body = body;
            this.users = users;
        }
    }

    public static class User {
        public final String name;
        public final String age;

        public User(String name, String age) {
            this.name = name;
            this.age = age;
        }
    }
}

