/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Test;

public class BeanWithHeaderTest
extends ContextTestSupport {
    @Test
    public void testBeanWithHeader() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"StartMyBeanMyBean"});
        mock.expectedHeaderReceived("foo", (Object)"bar");
        mock.expectedHeaderReceived("user", (Object)"admin");
        this.template.requestBody("direct:in", (Object)"Start");
        mock.assertIsSatisfied();
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry answer = super.createCamelRegistry();
        answer.bind("myBean", (Object)new MyBean());
        return answer;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from("direct:in").setHeader("foo", (Expression)this.constant("bar"))).to("bean:myBean")).to("seda:a");
                ((RouteDefinition)this.from("seda:a").to("bean:myBean")).to("mock:result");
            }
        };
    }

    public static class MyBean {
        public void doSomething(Exchange exchange) {
            String body = (String)exchange.getIn().getBody(String.class);
            exchange.getIn().setHeader("user", (Object)"admin");
            exchange.getIn().setBody((Object)(body + "MyBean"));
        }
    }
}

