/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.language.simple.Simple;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BeanWithExpressionInjectionPredicateTest
extends ContextTestSupport {
    protected final MyBean myBean = new MyBean();

    @Test
    public void testSendMessage() {
        this.template.sendBody("direct:in", (Object)"Hello");
        Assertions.assertEquals((Object)"Hello", (Object)this.myBean.body);
        Assertions.assertFalse((boolean)this.myBean.foo);
    }

    @Test
    public void testSendMessageWithFoo() {
        this.template.sendBodyAndHeader("direct:in", (Object)"Hello", "foo", (Object)123);
        Assertions.assertEquals((Object)"Hello", (Object)this.myBean.body);
        Assertions.assertTrue((boolean)this.myBean.foo);
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry answer = super.createCamelRegistry();
        answer.bind("myBean", (Object)this.myBean);
        return answer;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:in").bean((Object)"myBean");
            }
        };
    }

    public static class MyBean {
        public String body;
        public boolean foo;

        public void read(String body, @Simple(value="${header.foo} != null") boolean foo) {
            this.body = body;
            this.foo = foo;
        }
    }
}

