/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.ExchangeException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.bean.MyCustomException;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BeanWithExchangeExceptionAnnotationTest
extends ContextTestSupport {
    @Test
    public void testBeanWithAnnotationAndExchangeTest() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        MockEndpoint error = this.getMockEndpoint("mock:error");
        result.expectedMessageCount(0);
        error.expectedMessageCount(1);
        error.expectedBodiesReceived(new Object[]{"The Body"});
        this.template.requestBody("direct:start", (Object)"The Body");
        result.assertIsSatisfied();
        error.assertIsSatisfied();
    }

    protected Object getBean() {
        return new MyBean();
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry answer = super.createCamelRegistry();
        answer.bind("myBean", this.getBean());
        return answer;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:error"));
                ((OnExceptionDefinition)this.onException(MyCustomException.class).maximumRedeliveries(0).handled(true).bean((Object)"myBean", "handleException")).to("mock:error");
                ((RouteDefinition)this.from("direct:start").bean((Object)"myBean", "throwException")).to("mock:result");
            }
        };
    }

    public static class MyBean {
        private static final String MESSAGE = "I'm being thrown from " + String.valueOf(BeanWithExchangeExceptionAnnotationTest.class);

        public void throwException() throws MyCustomException {
            throw new MyCustomException(MESSAGE);
        }

        public void handleException(@ExchangeException Exception exception) {
            Assertions.assertNotNull((Object)exception);
            Assertions.assertEquals((Object)MESSAGE, (Object)exception.getMessage());
        }
    }
}

